define("core/local/collapsable_section/events",["exports","core/event_dispatcher"],(function(_exports,_event_dispatcher){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.notifyCollapsableSectionShown=_exports.notifyCollapsableSectionHidden=_exports.eventTypes=void 0;
/**
   * The collapsable section events.
   *
   * This module wraps the standard bootstrap collapsable events, but for collapsable sections.
   *
   * @module     core/local/collapsable_section/events
   * @copyright  2024 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   *
   * @example <caption>Example of listening to a collapsable section events.</caption>
   * import {eventTypes as collapsableSectionEventTypes} from 'core/local/collapsable_section/events';
   *
   * document.addEventListener(collapsableSectionEventTypes.shown, event => {
   *     window.console.log(event.target); // The HTMLElement relating to the block whose content was updated.
   * });
   */
const eventTypes={shown:"core_collapsable_section_shown",hidden:"core_collapsable_section_hidden",hideBsCollapse:"hide.bs.collapse",hiddenBsCollapse:"hidden.bs.collapse",showBsCollapse:"show.bs.collapse",shownBsCollapse:"shown.bs.collapse"};_exports.eventTypes=eventTypes;_exports.notifyCollapsableSectionShown=element=>(0,_event_dispatcher.dispatchEvent)(eventTypes.shown,{},element);_exports.notifyCollapsableSectionHidden=element=>(0,_event_dispatcher.dispatchEvent)(eventTypes.hidden,{},element)}));

//# sourceMappingURL=events.min.js.map